<?php
    $err   = 'iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAMAAAAoyzS7AAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAAGUExURf8AAAAAAEGjEgMAAAAMSURBVHjaYmAACDAAAAIAAU9tWeEAAAAASUVORK5CYII='; //red dot
    
    $types   = array('jpg'=>array('type'=>'images/pjpeg'
                                 ,'maxw'=>150)
                    ,'png'=>array('type'=>'image/png'
                                 ,'maxw'=>150));
    $imgtype = "";
    $imgname = "";
    
    if(!isset($_SERVER['QUERY_STRING']))
    {
        headers("error.png","image/png");
        print base64_decode($err);
        exit;
    }
    
    $img = urldecode($_SERVER['QUERY_STRING']);
    
    if(!preg_match("@^http[s]?://.+\.(gif|png|jp[e]?g)$@i",$img))
    {
        headers("error.png","image/png");
        print base64_decode($err);
        exit;
    }
    
    $imgtype = preg_match("@.\jp[e]?g$@i",$img)? 'jpg' : 'png';
    $imgname = preg_replace("@^.+/([^/]*)\.[a-z]{3}$@","\\1",$img);
    
    $imgdata = file_get_contents($img);
    
    $im = imagecreatefromstring($imgdata);

    if ($im !== false)
    {
        make_thumb(&$im, $imgtype, $imgname,$types);
    }
    else
    {
        headers("error.png","image/png");
        print base64_decode($err);
        exit;
    }
    /*************************************/
    
    function headers($filename, $type)
    {
        header("Pragma: public");
        header("Expires: 0");
        header("Cache-control: private");
        header('Content-type: '.$type);
        header('Content-Disposition: inline; filename="'.$filename.'"');
    }    
    
    function make_thumb($im, $imgtype, $imgname, $types)
    {
        $width  = imagesx($im);
        $height = imagesy($im);
        
        $aspect_ratio = $height/$width;
        
        if ($width <= $types[$imgtype]['maxw'])
        {
            return_img(&$im, $imgtype, $imgname, $types);
            exit;
        }
        
        $new_w = $types[$imgtype]['maxw'];
        $new_h = abs($new_w * $aspect_ratio);
        
        $img = imagecreatetruecolor($new_w,$new_h);
        imagecopyresized($img,$im,0,0,0,0,$new_w,$new_h,$width,$height);
        imagedestroy($im);
        
        return_img(&$img, $imgtype, $imgname, $types);
        exit;
    }
    
    function return_img($im, $imgtype, $imgname, $types)
    {
        headers("{$imgname}.{$imgtype}",$types[$imgtype]['type']);
        if($imgtype=='jpg')
        {
            imagejpeg($im);
        }
        else
        {
            $im = ImageTrueColorToPalette2($im,false,255);
            imagepng($im);
        }
        exit;
    }
    
    function ImageTrueColorToPalette2($image, $dither, $ncolors)
    {
        $width = imagesx( $image );
        $height = imagesy( $image );
        $colors_handle = ImageCreateTrueColor( $width, $height );
        ImageCopyMerge( $colors_handle, $image, 0, 0, 0, 0, $width, $height, 100 );
        ImageTrueColorToPalette( $image, $dither, $ncolors );
        ImageColorMatch( $colors_handle, $image );
        ImageDestroy($colors_handle);
        return $image;
    }

    
?>